/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MegaUtils;
import com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti;
import com.github.bartimaeusnek.crossmod.tectech.helper.TecTechUtils;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.tiered.LowPowerLaser;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_ElectricBlastFurnace;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

@Optional.Interface(iface="com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti", modid="tectech", striprefs=true)
public class GT_TileEntity_MegaBlastFurnace
extends GT_MetaTileEntity_ElectricBlastFurnace
implements TecTechEnabledMulti {
    private int mHeatingCapacity;
    private byte glasTier;
    private int polPtick = super.getPollutionPerTick(null) * ConfigHandler.megaMachinesMax;
    static Field controllerY;
    public ArrayList TTTunnels = new ArrayList();
    public ArrayList TTMultiAmp = new ArrayList();
    private byte circuitMode = 0;
    private long lEUt = 0L;

    public GT_TileEntity_MegaBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaBlastFurnace(String aName) {
        super(aName);
    }

    public String[] getDescription() {
        String[] dsc = StatCollector.func_74838_a((String)"tooltip.tile.mbf.0.name").split(";");
        String tmp = dsc[dsc.length - 1];
        dsc[dsc.length - 1] = tmp + " " + 20 * this.getPollutionPerTick(null) + " " + StatCollector.func_74838_a((String)"tooltip.tile.mbf.1.name");
        String[] fdsc = new String[dsc.length + 1];
        for (int i = 0; i < dsc.length; ++i) {
            fdsc[i] = dsc[i];
            fdsc[dsc.length] = BW_Tooltip_Reference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get();
        }
        return fdsc;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.circuitMode = aNBT.func_74771_c("circuitMode");
        this.glasTier = aNBT.func_74771_c("glasTier");
        this.lEUt = aNBT.func_74763_f("lEUt");
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.lEUt > 0L) {
            this.addEnergyOutput(this.lEUt * (long)this.mEfficiency / 10000L);
            return true;
        }
        if (this.lEUt < 0L && !this.drainEnergyInput(-this.lEUt * 10000L / (long)Math.max(1000, this.mEfficiency))) {
            this.stopMachine();
            return false;
        }
        return true;
    }

    public void stopMachine() {
        this.mOutputItems = null;
        this.mEUt = 0;
        this.lEUt = 0L;
        this.mEfficiency = 0;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 0;
        this.mEfficiencyIncrease = 0;
        this.getBaseMetaTileEntity().disableWorking();
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.circuitMode = (byte)(this.circuitMode - 1);
            if (this.circuitMode < 0) {
                this.circuitMode = (byte)24;
            }
        } else {
            this.circuitMode = (byte)(this.circuitMode + 1);
            if (this.circuitMode > 24) {
                this.circuitMode = 0;
            }
        }
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.circuitMode > 0 ? "MEBF will prioritise circuit: " + this.circuitMode : "Circuit prioritisation disabled."));
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("glasTier", this.glasTier);
        aNBT.func_74774_a("circuitMode", this.circuitMode);
        aNBT.func_74772_a("lEUt", this.lEUt);
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (LoaderReference.tectech) {
            return TecTechUtils.addEnergyInputToMachineList(this, aTileEntity, aBaseCasingIndex);
        }
        return super.addEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    protected byte calculateOverclockednessEBF(long aEUt, int aDuration, long maxInputVoltage) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier((long)maxInputVoltage));
        byte timesOverclocked = 0;
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.lEUt = 0x7FFFFFFEL;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.lEUt = (int)(aEUt >> 2);
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            while (tempEUt <= GT_Values.V[mTier - 1]) {
                tempEUt <<= 2;
                this.mMaxProgresstime >>= 1;
                xEUt = this.mMaxProgresstime <= 0 ? xEUt >> 1 : xEUt << 2;
                timesOverclocked = (byte)(timesOverclocked + 1);
            }
            if (xEUt > maxInputVoltage) {
                xEUt >>= 2;
                this.mMaxProgresstime <<= 1;
                timesOverclocked = (byte)(timesOverclocked - 1);
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.lEUt = 0x7FFFFFFEL;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.lEUt = (int)xEUt;
                if (this.lEUt == 0L) {
                    this.lEUt = 1L;
                }
                if (this.mMaxProgresstime <= 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
        return timesOverclocked;
    }

    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler e : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)e)) continue;
            mPollutionReduction = Math.max(e.calculatePollutionReduction(this.mPollution), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        if (LoaderReference.tectech) {
            long[] info = this.getCurrentInfoData();
            storedEnergy = info[0];
            maxEnergy = info[1];
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + this.mProgresstime / 20 + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + storedEnergy + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + maxEnergy + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + -this.lEUt + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + this.getMaxInputVoltage() + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier((long)this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }

    public boolean drainEnergyInput(long aEU) {
        if (LoaderReference.tectech) {
            return TecTechUtils.drainEnergyMEBFTecTech(this, aEU);
        }
        return MegaUtils.drainEnergyMegaVanilla((GT_MetaTileEntity_MultiBlockBase)this, aEU);
    }

    public long getMaxInputVoltage() {
        if (LoaderReference.tectech) {
            return TecTechUtils.getMaxInputVoltage(this);
        }
        return super.getMaxInputVoltage();
    }

    private boolean getCoilHeat(IGregTechTileEntity iGregTechTileEntity, int y) {
        int xDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetX * 7;
        int zDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetZ * 7;
        int internalH = 0;
        for (int x = -6; x <= 6; ++x) {
            for (int z = -6; z <= 6; ++z) {
                if (Math.abs(x) < 6 && Math.abs(z) != 6) continue;
                byte tUsedMeta = iGregTechTileEntity.getMetaIDOffset(xDir + x, y, zDir + z);
                switch (tUsedMeta) {
                    case 0: {
                        internalH = 1801;
                        break;
                    }
                    case 1: {
                        internalH = 2701;
                        break;
                    }
                    case 2: {
                        internalH = 3601;
                        break;
                    }
                    case 3: {
                        internalH = 4501;
                        break;
                    }
                    case 4: {
                        internalH = 5401;
                        break;
                    }
                    case 5: {
                        internalH = 7201;
                        break;
                    }
                    case 6: {
                        internalH = 9001;
                        break;
                    }
                    case 7: {
                        internalH = 9901;
                        break;
                    }
                    case 8: {
                        internalH = 10801;
                        break;
                    }
                    case 9: {
                        internalH = 21601;
                        break;
                    }
                }
                if (this.mHeatingCapacity > 0 && internalH != this.mHeatingCapacity) {
                    return false;
                }
                if (this.mHeatingCapacity != 0) continue;
                this.mHeatingCapacity = internalH;
            }
        }
        return true;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return this.polPtick;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_MegaBlastFurnace(this.mName);
    }

    public boolean checkRecipe(ItemStack itemStack) {
        int processed;
        GT_Recipe tRecipe;
        ItemStack[] tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
        FluidStack[] tFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        long nominalV = LoaderReference.tectech ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)nominalV));
        if (this.circuitMode > 0 && Arrays.stream(tInputs).anyMatch(e -> GT_Utility.areStacksEqual((ItemStack)e, (ItemStack)GT_Utility.getIntegratedCircuit((int)this.circuitMode), (boolean)true))) {
            List<ItemStack> modInputs = Arrays.stream(tInputs).filter(Objects::nonNull).filter(e -> !e.func_77973_b().equals(GT_Utility.getIntegratedCircuit((int)this.circuitMode).func_77973_b())).collect(Collectors.toList());
            modInputs.add(GT_Utility.getIntegratedCircuit((int)this.circuitMode));
            tInputs = modInputs.toArray(new ItemStack[0]);
        }
        if ((tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs)) == null) {
            if (this.circuitMode == 0) {
                return false;
            }
            tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
            tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            if (tRecipe == null) {
                return false;
            }
        }
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        boolean found_Recipe = false;
        int tHeatCapacityDivTiers = (this.mHeatingCapacity - tRecipe.mSpecialValue) / 900;
        long precutRecipeVoltage = (long)((double)tRecipe.mEUt * Math.pow(0.95, tHeatCapacityDivTiers));
        for (processed = 0; this.getStoredInputs().size() > 0 && processed < ConfigHandler.megaMachinesMax && this.mHeatingCapacity >= tRecipe.mSpecialValue && precutRecipeVoltage * (long)(processed + 1) < nominalV && tRecipe.isRecipeInputEqual(true, tFluids, tInputs); ++processed) {
            int i;
            found_Recipe = true;
            for (i = 0; i < tRecipe.mOutputs.length; ++i) {
                outputItems.add(tRecipe.getOutput(i));
            }
            for (i = 0; i < tRecipe.mFluidOutputs.length; ++i) {
                outputFluids.add(tRecipe.getFluidOutput(i));
            }
        }
        if (found_Recipe) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            long actualEUT = precutRecipeVoltage * (long)processed;
            byte overclockCount = this.calculateOverclockednessEBF(actualEUT, tRecipe.mDuration, nominalV);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.lEUt == 0x7FFFFFFEL) {
                return false;
            }
            if (this.lEUt > 0L) {
                this.lEUt = -this.lEUt;
            }
            if (tHeatCapacityDivTiers > 0) {
                this.mMaxProgresstime >>= Math.min(tHeatCapacityDivTiers / 2, overclockCount);
                if (this.mMaxProgresstime < 1) {
                    this.mMaxProgresstime = 1;
                }
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.polPtick = super.getPollutionPerTick(null) * processed;
            this.mOutputItems = new ItemStack[outputItems.size()];
            this.mOutputItems = outputItems.toArray(this.mOutputItems);
            this.mOutputFluids = new FluidStack[outputFluids.size()];
            this.mOutputFluids = outputFluids.toArray(this.mOutputFluids);
            this.updateSlots();
            return true;
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        try {
            controllerY.set(this, iGregTechTileEntity.getYCoord() - 2);
        }
        catch (IllegalAccessException e) {
            MainMod.LOGGER.catching((Throwable)e);
        }
        if (LoaderReference.tectech) {
            this.getTecTechEnergyMultis().clear();
            this.getTecTechEnergyTunnels().clear();
        }
        this.mHeatingCapacity = 0;
        boolean ret = BW_Util.check_layer(iGregTechTileEntity, 7, -2, -1, GregTech_API.sBlockCasings1, 11, 7, false, false, true, GregTech_API.sBlockCasings1, 11, true, 11);
        ret &= BW_Util.check_layer(iGregTechTileEntity, 7, 17, 18, GregTech_API.sBlockCasings1, 11, 7, false, null, -1, 11);
        ret &= BW_Util.check_layer(iGregTechTileEntity, 6, -1, 17, GregTech_API.sBlockCasings5, -1, 7, false, false, true, Blocks.field_150350_a, -1, false, 11);
        for (int y = -1; y < 17; ++y) {
            ret &= BW_Util.check_layer(iGregTechTileEntity, 7, y, y + 1, ItemRegistry.bw_glasses[0], -1, 7, y == 0, false, false, null, -1, false, 11);
            if (!this.getCoilHeat(iGregTechTileEntity, y)) {
                return false;
            }
            List<Byte> metasFromLayer = BW_Util.getMetasFromLayer(iGregTechTileEntity, 7, y, y + 1, 7, y == 0, false, false);
            for (Byte meta : metasFromLayer) {
                byte inttier = BW_Util.getTierFromGlasMeta(meta.byteValue());
                if (this.glasTier > 0 && inttier != this.glasTier) {
                    return false;
                }
                if (this.glasTier != 0) continue;
                this.glasTier = inttier;
            }
        }
        int xDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetX * 7;
        int zDir = ForgeDirection.getOrientation((int)iGregTechTileEntity.getBackFacing()).offsetZ * 7;
        for (int z = -6; z <= 6; ++z) {
            for (int x = -6; x <= 6; ++x) {
                if (this.addMufflerToMachineList(iGregTechTileEntity.getIGregTechTileEntityOffset(xDir + x, 17, zDir + z), 11)) continue;
                return false;
            }
        }
        if (LoaderReference.tectech && this.glasTier != 8 && (!this.areLazorsLowPowa() || this.areThingsNotProperlyTiered(this.getTecTechEnergyTunnels()) || this.areThingsNotProperlyTiered(this.getTecTechEnergyMultis()))) {
            return false;
        }
        if (this.glasTier != 8 && !this.mEnergyHatches.isEmpty()) {
            for (GT_MetaTileEntity_Hatch_Energy hatchEnergy : this.mEnergyHatches) {
                if (this.glasTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        return ret && !this.mMaintenanceHatches.isEmpty() && !this.mOutputBusses.isEmpty() && !this.mInputBusses.isEmpty();
    }

    @Optional.Method(modid="tectech")
    private boolean areThingsNotProperlyTiered(Collection collection) {
        if (!collection.isEmpty()) {
            for (Object tecTechEnergyMulti : collection) {
                if (((GT_MetaTileEntity_TieredMachineBlock)tecTechEnergyMulti).mTier <= this.glasTier) continue;
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="tectech")
    private boolean areLazorsLowPowa() {
        List collection = this.getTecTechEnergyTunnels();
        if (!collection.isEmpty()) {
            for (Object tecTechEnergyMulti : collection) {
                if (tecTechEnergyMulti instanceof LowPowerLaser) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Optional.Method(modid="tectech")
    public List<GT_MetaTileEntity_Hatch_Energy> getVanillaEnergyHatches() {
        return this.mEnergyHatches;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyTunnels() {
        return this.TTTunnels;
    }

    @Optional.Method(modid="tectech")
    public List getTecTechEnergyMultis() {
        return this.TTMultiAmp;
    }

    static {
        try {
            controllerY = GT_MetaTileEntity_ElectricBlastFurnace.class.getDeclaredField("controllerY");
        }
        catch (NoSuchFieldException e) {
            MainMod.LOGGER.catching((Throwable)e);
        }
        controllerY.setAccessible(true);
    }
}

